/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.diff.tree.ExclusionPattern;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FilterPanel
extends JPanel {
    public static final String ACTION_ACCEPT = "ACCEPT";
    public static final String ACTION_DISCARD = "DISCARD";
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private JButton acceptButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JScrollPane patternScroll;
    private JTextArea patternText;
    private JLabel title;
    private JCheckBox updateGlobalList;

    public FilterPanel() {
        this.initComponents();
    }

    public void setPatterns(List<ExclusionPattern> patterns) {
        StringBuilder sb = new StringBuilder();
        for (ExclusionPattern ep : patterns) {
            sb.append(ep.getPattern());
            sb.append("\n");
        }
        this.patternText.setText(sb.toString());
    }

    public List<ExclusionPattern> getPatterns() {
        ArrayList<ExclusionPattern> result = new ArrayList<ExclusionPattern>();
        for (String line : this.patternText.getText().split("\n")) {
            if (line.trim().isEmpty()) continue;
            ExclusionPattern ep = new ExclusionPattern();
            ep.setType(ExclusionPattern.ExclusionType.WILDCARD);
            ep.setPattern(line);
            result.add(ep);
        }
        return result;
    }

    public void setUpdateGlobalList(boolean value) {
        this.updateGlobalList.setSelected(value);
    }

    public boolean isUpdateGlobalList() {
        return this.updateGlobalList.isSelected();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void initComponents() {
        this.title = new JLabel();
        this.jLabel1 = new JLabel();
        this.patternScroll = new JScrollPane();
        this.patternText = new JTextArea();
        this.buttonPanel = new JPanel();
        this.updateGlobalList = new JCheckBox();
        this.cancelButton = new JButton();
        this.acceptButton = new JButton();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(540, 400));
        this.setLayout(new GridBagLayout());
        this.title.setFont(this.title.getFont().deriveFont(this.title.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.title, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.title.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.title, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.jLabel1.text"));
        this.jLabel1.setAlignmentY(0.0f);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.patternText.setColumns(20);
        this.patternText.setLineWrap(true);
        this.patternText.setRows(5);
        this.patternText.setWrapStyleWord(true);
        this.patternScroll.setViewportView(this.patternText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.patternScroll, gridBagConstraints);
        FlowLayout flowLayout1 = new FlowLayout();
        flowLayout1.setAlignOnBaseline(true);
        this.buttonPanel.setLayout(flowLayout1);
        this.updateGlobalList.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.updateGlobalList, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.updateGlobalList.text"));
        this.buttonPanel.add(this.updateGlobalList);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        Mnemonics.setLocalizedText((AbstractButton)this.acceptButton, (String)NbBundle.getMessage(FilterPanel.class, (String)"FilterPanel.acceptButton.text"));
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterPanel.this.acceptButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.acceptButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 768;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        ActionEvent ae = new ActionEvent(this, 1001, ACTION_ACCEPT);
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(ae);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        ActionEvent ae = new ActionEvent(this, 1001, ACTION_DISCARD);
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(ae);
        }
    }
}

